## -*-Tcl-*-
 # ###################################################################
 #  HTML mode 2.1.4: tools for editing HTML documents
 # 
 #  FILE: "htmlMode.tcl"
 #                                    created: 95-04-26 14.49.04 
 #                                last update: 99-04-24 12.15.58 
 #  Author: Johan Linde
 #  E-mail: <jlinde@telia.com>
 #     www: <http://www.theophys.kth.se/~jl/Alpha.html>
 #  
 # Version: 2.1.4
 # 
 # version 0.24 (16 July 95) by Scott W. Brim <swb1@cornell.edu>
 # version 1.0 -- 2.1.4 (April 99) by Johan Linde <jlinde@telia.com>
 #
 # Copyright 1996-1999 by Johan Linde
 #  
 # This software may be used freely, and distributed freely, as long as the 
 # receiver is not obligated in any way by receiving it.
 #  
 # If you make improvements to this file, please share them!
 # 
 # ###################################################################
 ##

if {[alpha::package vsatisfies ${alpha::version} 7.1b1]} {
alpha::mode HTML 2.1.4 htmlMenu \
  {*.html *.htm *.shtml *.HTML *.HTM *.SHTML } {
	htmlMenu htmlUtilsMenu electricBraces electricSemicolon electricReturn electricTab
} {
	addMenu 	htmlMenu
	addMenu 	htmlUtilsMenu
	lunion mode::features(HTML) -betterTemplates
} uninstall {
	set __dir [file dirname [procs::find htmlMenu]]
	foreach __file {Mode 40 Custom Elems Engine Entities HomePageUtils Menu StatusBar Utils} {
		catch {removeFile $__dir:html${__file}.tcl}
	}
	catch {removeFile "$HOME:Tcl:Completions:HTMLCompletions.tcl"}
	if {[procs::find cssMenu] == ""} {
		catch {removeFile $__dir:hctsmsl.tcl}
		catch {removeFile $__dir:hctsmslShared.tcl}
		catch {removeFile $__dir:hctsmslMenu.tcl}
		catch {removeFile "$HOME:Help:HTML Help"}
		catch {removeFile "$HOME:Tcl:Completions:CSSCompletions.tcl"}
	}
} maintainer {
	"Johan Linde" jlinde@telia.com <http://www.theophys.kth.se/~jl/Alpha.html>
} help {file "HTML Help"}
catch {unset HTMLmodeVars(elecRBrace)}
catch {unset HTMLmodeVars(elecLBrace)}
catch {unset HTMLmodeVars(electricSemi)}
catch {unset HTMLmodeVars(electricTab)}
} else {
;alpha::mode HTML 2.1.4 htmlMenu \
  {*.html *.htm *.shtml *.HTML *.HTM *.SHTML } {htmlMenu htmlUtilsMenu} {
	addMenu 	htmlMenu
	addMenu 	htmlUtilsMenu
} uninstall {
	set __dir [file dirname [procs::find htmlMenu]]
	foreach __file {Mode 40 Custom Elems Engine Entities HomePageUtils Menu StatusBar Utils} {
		catch {removeFile $__dir:html${__file}.tcl}
	}
	catch {removeFile "$HOME:Tcl:Completions:HTMLCompletions.tcl"}
	if {[procs::find cssMenu] == ""} {
		catch {removeFile $__dir:hctsmsl.tcl}
		catch {removeFile $__dir:hctsmslShared.tcl}
		catch {removeFile $__dir:hctsmslMenu.tcl}
		catch {removeFile "$HOME:Help:HTML Help"}
		catch {removeFile "$HOME:Tcl:Completions:CSSCompletions.tcl"}
	}
} maintainer {
	"Johan Linde" jlinde@telia.com <http://www.theophys.kth.se/~jl/Alpha.html>
} help {file "HTML Help"}
# Electric left brace?
newPref f elecRBrace 1 HTML
# Electric right brace?
newPref f elecLBrace 1 HTML
# Electric semi colon?
newPref f electricSemi 1 HTML
newPref f electricTab 1 HTML
}

# called by Alpha to load HTML in.  
proc htmlMenu {} {}
proc htmlUtilsMenu {} {}

# A few definitions so that HTML mode runs with Alpha 7.0.
if {![info exists elecStopMarker]} {
	set elecStopMarker 
}
if {![alpha::package vsatisfies ${alpha::version} 7.0p5]} {
;proc is::Whitespace {anyString} {
	return [regexp "^\[ \t\r\n\]*$" $anyString]
}
;proc is::UnsignedInteger {str1} {
	return [regexp {^[0-9]+$} [string trim $str1]]
}
;proc is::PositiveInteger {str1} {
	if [is::UnsignedInteger $str1] {
		return [expr $str1 > 0]
	}
	return 0
}
}
if {![alpha::package vsatisfies ${alpha::version} 7.1b1]} {
;proc bind::fromArray {arr bindarr {unbind 0} {mode {}}} {
	upvar $arr ar
	upvar $bindarr br
	set r {}
	if {$unbind} {
		set bindcmd "unbind"
	} else {
		set bindcmd "bind"
	}
	foreach a [array names ar] {
		if {[set b $ar($a)] != ""} {
			if [info exists br($a)] {
				catch {eval $bindcmd [keys::toBind $b] [list $br($a)] $mode}
			} else {
				beep; message "Bad bind-array entry '$a'"
			}
		}
	}
}
;proc ::indentRegion {} {indentRegion}
}


#===============================================================================
# Global variables and their management
#===============================================================================

# Unsetting some old prefs
foreach _tmp {htmlPackageToUse hideNetscape hideIE inclEventHandler hideStyleAttrs useAttsApplyToDialogs} {
	catch {unset HTMLmodeVars($_tmp)}
}

set htmlIconTxt {"Netscape Navigator 3" "Netscape Navigator 4" "Netscape Communicator" "Internet Explorer" Cyberdog MacLynx Mosaic}
set htmlIcons {135 293 294 295 281 296 942}

# Menu icons
newPref v htmlMenuIcon 294 HTML
newPref v htmlUtilsMenuIcon 281 HTML

if {$HTMLmodeVars(htmlMenuIcon) == $HTMLmodeVars(htmlUtilsMenuIcon)} {
	foreach _tmp $htmlIcons {
		if {$HTMLmodeVars(htmlMenuIcon) != $_tmp} {
			set HTMLmodeVars(htmlUtilsMenuIcon) $_tmp
			lappend modifiedModeVars {htmlUtilsMenuIcon HTMLmodeVars}
			break
		}
	}
}

set htmlMenu $HTMLmodeVars(htmlMenuIcon)
set htmlUtilsMenu $HTMLmodeVars(htmlUtilsMenuIcon)

# Line width
newPref v fillColumn 75 HTML
newPref v leftFillColumn 0 HTML
# word breaking and word wrapping
newPref v wordBreak {\w+} HTML
newPref v wordBreakPreface {(\W)} HTML
newPref v wrapBreak {[\w_]+} HTML
newPref v wrapBreakPreface {([^\w_])} HTML
newPref f wordWrap	1 HTML

# Indentation
newPref f indentAPPLET 0 HTML
newPref f indentBLOCKQUOTE 0 HTML
newPref f indentBODY 0 HTML
newPref f indentCENTER 0 HTML
newPref f indentDIR 1 HTML
newPref f indentDIV 0 HTML
newPref f indentDL 1 HTML
newPref f indentFIELDSET 0 HTML
newPref f indentFORM 0 HTML
newPref f indentFRAMESET 0 HTML
newPref f indentHEAD 0 HTML
newPref f indentMAP 0 HTML
newPref f indentMENU 1 HTML
newPref f indentMULTICOL 0 HTML
newPref f indentNOEMBED 0 HTML
newPref f indentNOFRAMES 0 HTML
newPref f indentNOSCRIPT 0 HTML
newPref f indentOBJECT 0 HTML
newPref f indentOL 1 HTML
newPref f indentOPTGROUP 0 HTML
newPref f indentP 0 HTML
newPref f indentSELECT 0 HTML
newPref f indentTABLE 1 HTML
newPref f indentTR 1 HTML
newPref f indentUL 1 HTML
set htmlIndentElements {HEAD BODY P DIV BLOCKQUOTE CENTER MULTICOL OBJECT NOEMBED OL UL DIR MENU DL
FORM FIELDSET SELECT OPTGROUP TABLE TR FRAMESET NOFRAMES MAP APPLET NOSCRIPT}

# browsers
if {![info exists browserSig] && [catch {getFileSig [icGetPref -t 1 Helperhttp]} browserSig]} {set browserSig MOSS}
# Browser signatures
newPref v browsers {MOSS MSIE} HTML

newPref v prefixString	"<!-- " HTML
newPref v suffixString	" -->" HTML

# Paths to footer files.
newPref v footers {} HTML
# Tag color
newPref v tagColor		blue HTML
# Attribute color
newPref v attributeColor magenta HTML
# Simple coloring?
newPref f simpleColoring 0 HTML
# Should elements be lower case?
newPref f useLowerCase	0 HTML
# Should 's be inserted?
newPref	f useTabMarks	1 HTML
# Is <p> a container?
newPref f pIsContainer	1 HTML
# Are LI DT and DD containers 
newPref f lidtAreContainers 0  HTML
# A window cache with frames.
newPref v windows		{} HTML
# When browser is launched, should it be brought to front?
newPref	f browseInForeground	1 HTML
# Save without asking when sending file to browser?
newPref f saveWithoutAsking 0 HTML
# Default list of commonly used character entities
newPref v defaultCommonChars {"less than" "greater than" "ampersand" "nonbreak space"} HTML
# List of commonly used character entities
newPref v commonChars $HTMLmodeVars(defaultCommonChars) HTML
# Never ask about extensions?
newPref f hideExtensions 0 HTML
# Never ask about deprecated elements and attributes?
newPref f hideDeprecated 0 HTML
# Attributes globally not asked about at first
newPref v dontaskforAttributes {} HTML
# Attributes globally never asked about
newPref v neveraskforAttributes {} HTML
# Attributes globally always asked about
newPref v alwaysaskforAttributes {} HTML
# Beep when asking for attributes in the status bar?
newPref f promptNoisily 1 HTML
# Flash status bar for first attribute?
newPref f flashStatusBar 1 HTML
# Input from dialog windows or status bar?
newPref f useBigWindows 1 HTML
# Change attributes in dialog windows or status bar?
newPref f changeInBigWindows 1 HTML
# Cmd-double-click on non text file link opens file?
newPref f openNonTextFile 1 HTML
# Return on non text file in home page window opens file?
newPref f homeOpenNonTextFile 1 HTML
# Check anchors in links?
newPref f checkAnchors 1 HTML
# Case sensistive link checking?
newPref f caseSensitive 0 HTML
# Check links with Big Brother?
newPref f useBigBrother 0 HTML
newPref f checkInFront 1 HTML
newPref f useBBoptions 1 HTML
newPref f ignoreRemote 0 HTML
newPref f ignoreLocal 0 HTML
# Folder for HTML manual.
newPref v manualFolder "$HOME:HTML mode manual" HTML
newPref v manualStartPage 0 HTML
# FTP servers
newPref v FTPservers {} HTML
# Last modified string
newPref v lastModified "Last modified" HTML
# 'Insert include tags' only inserts tags, and not the file?
newPref f includeOnlyTags 1 HTML
# Color JavaScript keywords?
newPref f JavaScriptColoring 0 HTML
# Color of JavaScript keywords
newPref v JavaScriptColor	magenta HTML
# Color of strings
newPref v stringColor green HTML
# Color of JavaScript comments
newPref v JavaCommentColor red HTML
# Color CSS keywords?
newPref f CSSColoring 0 HTML
# Color of CSS keywords
newPref v CSSColor cyan HTML


# These attributes are URLs.
set htmlURLAttr	{HREF= SRC= LOWSRC= ACTION= USEMAP= BACKGROUND= CODEBASE= PLUGINSPAGE=
DYNSRC= CLASSID= DATA= CITE= LONGDESC= PROFILE=}
# These element attributes are colors
set htmlColorAttr	{BGCOLOR= TEXT= LINK= VLINK= ALINK= COLOR= BORDERCOLOR=
BORDERCOLORDARK= BORDERCOLORLIGHT=}
# These attributes are windows
set htmlWindowAttr {TARGET=}
# Special cases with URLs, colors and windows
set htmlSpecURL {}
set htmlSpecColor {}
set htmlSpecWindow {}
# These elements can be in document HEAD.
set htmlHeadElements1 {BASE ISINDEX LINK META STYLE SCRIPT OBJECT}
# These elements are plug-ins.
set htmlPlugins {EMBED LIVEAUDIO LIVEVIDEO "QUICKTIME MOVIE" "QUICKTIME VR" REALAUDIO}
# HTML mode version
set htmlVersion 2.14

# Register eventhandler for Big Brother events
eventHandler Bbth Chkd htmlBbthChkdHandler 

# Used by fillParagraph
set htmlParaCommands {html|head|title|body|h[1-6]|p|div|blockquote|center|address|pre|multicol}
append htmlParaCommands {|br|hr|wbr|basefont|ul|ol|li|dir|menu|dl|dd|dt|form|input}
append htmlParaCommands {|select|option|textarea|caption|table|tr|frameset|frame|noframes}
append htmlParaCommands {|map|area|applet|param|script|noscript|layer|ilayer|nolayer|base|link|meta|isindex}
append htmlParaCommands {|col|colgroup|marquee|object|thead|tbody|tfoot}
append htmlParaCommands {|bdo|ins|del|fieldset|legend|button|optgroup}

#
# Internal Globals
#
set htmlCurSel	""
set htmlIsSel	0
set htmlAdditionExist 0
set htmlHomePageWinList {}
set homeTime 0
set htmlNumBbthChecking 0
set htmlHideDeprecated 0
set htmlHideExtensions 0
set htmlHideFrames 0

# Load other HTML mode files.
foreach tmp {htmlEngine htmlElems htmlEntities htmlUtils hctsmslShared hctsmslMenu htmlMenu} {
	if {[info exists cssModeIsLoaded] && ($tmp == "hctsmslMenu" || $tmp == "hctsmslShared")} {continue}
	if { [catch {eval ${tmp}.tcl}] } {
		beep
		alertnote "Loading of ${tmp}.tcl failed"
		return
	}
}

if {(!$HTMLmodeVars(useBigWindows) || !$HTMLmodeVars(changeInBigWindows)) && [catch {htmlStatusBar.tcl}] } {
	beep
	alertnote "Loading of htmlStatusBar.tcl failed"
	return
}

# Silently add missing menu.
if {[info exists modeMenus(HTML)]} {
	if {[lsearch -exact $modeMenus(HTML) htmlMenu] < 0} {
		lappend modeMenus(HTML) htmlMenu
	}
	if {[lsearch -exact $modeMenus(HTML) htmlUtilsMenu] < 0} {
		lappend modeMenus(HTML) htmlUtilsMenu
	}
}
if {[info exists mode::features(HTML)]} {
	if {[lsearch -exact [set mode::features(HTML)] htmlMenu] < 0} {
		lappend mode::features(HTML) htmlMenu
	}
	if {[lsearch -exact [set mode::features(HTML)] htmlUtilsMenu] < 0} {
		lappend mode::features(HTML) htmlUtilsMenu
	}
}

# Clean up tmp files
if {[file exists $PREFS:HTMLtmp]} {
	if {[file exists $PREFS:HTMLtmp:incl]} {catch {rm -r $PREFS:HTMLtmp:incl}}
	if {[file exists $PREFS:HTMLtmp:xincl]} {catch {rm -r $PREFS:HTMLtmp:xincl}}
	catch {rm $PREFS:HTMLtmp:*}
}


#
# Read custom elements
#

proc htmlReadAdditions {} {
	global PREFS htmlElemAttrRequired1 htmlElemAttrOptional1 htmlElemAttrChoices1
	global htmlElemAttrNumber1 htmlElemEventHandler1 htmlElemKeyBinding htmlElemProc
	global htmlURLAttr htmlColorAttr htmlWindowAttr htmlPlugins
	global htmlSpecURL htmlSpecColor htmlSpecWindow htmlVersion htmlShownWarning

	html40.tcl
	message "Loading custom elements"
	
	
	if {[catch {open $PREFS:HTMLadditions.tcl r} fid]} {
		alertnote "Could not open the file HTMLAdditions.tcl with your custom elements."
		return
	}
	set additions [read -nonewline $fid]
	close $fid
	set lines [split $additions "\n"]
	set version [lindex $lines 0]
	if {$version == $htmlVersion} {htmlReadAdditions0 $lines; return}
	if {$version > $htmlVersion} {
		regsub "\[^\n\]+" $additions $htmlVersion additions
		set fid [open $PREFS:HTMLadditions.tcl w]
		puts $fid $additions
		close $fid
		htmlReadAdditions0 $lines
		return
	}
	set allattrs [htmlGetAllAttrs]
	set newLines "$htmlVersion\n"
	set changed 0
	set tmpSpecURL ""
	set tmpSpecColor ""
	set tmpSpecWindow ""
	foreach line [lrange $lines 1 end] {
		set elem [lindex $line 0]
		set command [lindex $line 1]
		set elemExists [info exists htmlElemAttrOptional1($elem)]
		if {$elemExists} {
			foreach x [list AttrOptional1 AttrRequired1 AttrNumber1 AttrChoices1 EventHandler1] {
				if {[info exists htmlElem${x}($elem)]} {
					set $x [string toupper [set htmlElem${x}($elem)]]
				} else {
					set $x ""
				}
			}
			set attrs [concat $AttrOptional1 $AttrRequired1 $EventHandler1]
			foreach at $attrs {
				if {[string trimright $at =] == $at} {
					lappend attrs "${at}="
				} else {
					lappend attrs [string trimright $at =]
				}
			}
		} else {
			set attrs {}
		}
		set var [lindex $command 1]
		foreach ucw [list URL Color Window] {
			if {$var == "html${ucw}Attr"} {
				set att [lindex $command 2]
				if {[lsearch -exact [set html${ucw}Attr] $att] >=0} {
					# Already defined.
					set changed 1
				} elseif {[lsearch -exact $allattrs $att] >=0 || [lsearch -exact $allattrs [string trimright $att =]] >=0} {
					# Used for some other kind of attr.
					lappend ${ucw}SpecMaybe $att
					set changed 1
				} elseif {[lsearch -exact $attrs $att] >= 0} {
					# Attr already exists for elem.
					lappend ${ucw}Maybe $att
					set changed 1
				} else {
					append newLines "$line\n"
				}
			}
			if {$var == "htmlSpec${ucw}"} {
				set tmpadd [lrange $command 2 end]
				foreach x $tmpadd {
					regexp {[^!=]!?=(.*)} $x dum tmp
					# Only add if attr doesn't exist.
					if {[lsearch -exact $attrs $tmp] >= 0} {
						set changed 1
						set where [lsearch -exact $tmpadd $x]
						set tmpadd [lreplace $tmpadd $where $where]
					}
				}
				if {[llength $tmpadd]} {
					append newLines "[list $elem] \{lappend htmlSpec${ucw} $tmpadd\}\n"
					append tmpSpec${ucw} " " $tmpadd
				}
			}
		}
		if {[lsearch {htmlURLAttr htmlColorAttr htmlWindowAttr htmlSpecURL \
		htmlSpecColor htmlSpecWindow} $var] < 0} {
			# If element doesn't exist, GO!
			if {!$elemExists} {
				append newLines "$line\n"
				regsub "html" $command "tmp" command
				eval $command
				continue
			}
			# Skip these vars if element exists.
			if {[string match "htmlElemKeyBinding*" $var] || [string match "htmlElemProc*" $var] ||
			$var == "htmlPlugins"} {
				set changed 1
				continue
			}
			regexp {([^\(]+)\(([^\)]+)\)[ ]+(.+)} [lrange $command 1 end] dummy var arg added
			set added [string trimleft [string trimright $added \}] \{]
			foreach c $added {
				if {$var == "htmlElemAttrChoices1"} {
					regexp {[^=]*=} $c tmp
					# Don't add choices if they exist or if attr isn't a choice attr.
					if {[lsearch -exact $AttrChoices1 $c] >= 0 || ([lsearch -exact $attrs $tmp] >= 0 &&
					[lsearch $AttrChoices1 "${tmp}*"] < 0) } {
						set changed 1
						set where [lsearch -exact $added $c]
						set added [lreplace $added $where $where]
					}
				} else {
					if {$var == "htmlElemAttrNumber1"} {
						regexp {[^=]*=} $c tmp
					} else {
						set tmp [string toupper $c]
					}
					# Don't add attrs which exist.
					if {[lsearch -exact $attrs $tmp] >= 0} {
						set changed 1
						set where [lsearch -exact $added $c]
						set added [lreplace $added $where $where]
					}
				}
			}
			if {[llength $added]} {
				append newLines "[list $elem] \{lappend ${var}($arg) $added\}\n"
				regsub "html" $var "tmp" var
				eval "lappend ${var}($arg) $added"
			}
		}
	}
	foreach ucw [list URL Color Window] {
		if {[info exists ${ucw}SpecMaybe]} {
			foreach m [set ${ucw}SpecMaybe] {
				foreach e [array names tmpElemAttrRequired1] {
					if {[lsearch -exact $tmpElemAttrRequired1($e) $m] >= 0 && \
					[lsearch -exact [set tmpSpec$ucw] "$e!=[string trimright $m =]"] < 0} {
						append newLines "[list $e] \{lappend htmlSpec${ucw} ${e}=[string trimright $m =]\}\n"
					} 
				}
				foreach e [array names tmpElemAttrOptional1] {
					if {[lsearch -exact $tmpElemAttrOptional1($e) $m] >= 0 && \
					[lsearch -exact [set tmpSpec$ucw] "$e!=[string trimright $m =]"] < 0} {
						append newLines "[list $e] \{lappend htmlSpec${ucw} ${e}=[string trimright $m =]\}\n"
					} 
				}
			}
		}
		if {[info exists ${ucw}Maybe]} {
			foreach m [set ${ucw}Maybe] {
				set foundit 0
				foreach e [array names tmpElemAttrRequired1] {
					if {[lsearch -exact $tmpElemAttrRequired1($e) $m] >= 0 && \
					[lsearch -exact [set tmpSpec$ucw] "$e!=[string trimright $m =]"] < 0} {
						append newLines "[list $e] \{lappend html${ucw}Attr $m\}\n"
						set foundit 1
						break
					} 
				}
				if {$foundit} {continue}
				foreach e [array names tmpElemAttrOptional1] {
					if {[lsearch -exact $tmpElemAttrOptional1($e) $m] >= 0 && \
					[lsearch -exact [set tmpSpec$ucw] "$e!=[string trimright $m =]"] < 0} {
						append newLines "[list $e] \{lappend html${ucw}Attr $m\}\n"
						break
					} 
				}
			}
		}	
	}
	
	if {$newLines != "$htmlVersion\n"} {htmlReadAdditions0 [split [string trimright $newLines "\n"] "\n"]}
	if {$changed} {
		beep
		if {[lindex [dialog -w 300 -h 270 -b "Clean up" 20 240 100 260 \
		-b "Leave it" 120 240 200 260 -t "Some of your custom elements are supported by this\
		version of HTML mode." 10 10 290 45 -t "Choose 'Clean up' to update your file with custom\
		elements and to avoid this alert next time you run Alpha.\
		If you do so, some elements will not be defined correctly if you go back to\
		a previous version of HTML mode." 10 50 290 150 -t "Choose 'Leave it' to leave your file\
		with custom elements untouched. If you do so, the submenu 'Extend', where you can add new custom\
		elements, will be disabled." 10 160 290 225] 1]} {
			set htmlShownWarning 1
			return
		}
	}
	if {$newLines == "$htmlVersion\n"} {
		removeFile $PREFS:HTMLadditions.tcl
	} else {
		set fid [open $PREFS:HTMLadditions.tcl w]
		puts -nonewline $fid $newLines
		close $fid
	}
}

proc htmlReadAdditions0 {lines} {
	global htmlElemAttrRequired1 htmlElemAttrOptional1 htmlElemAttrChoices1
	global htmlElemAttrNumber1 htmlElemEventHandler1 htmlElemKeyBinding htmlElemProc
	global htmlURLAttr htmlColorAttr htmlWindowAttr htmlPlugins
	global htmlSpecURL htmlSpecColor htmlSpecWindow htmlAdditionExist htmlShownWarning
	
	foreach line [lrange $lines 1 end] {
		if {[catch {eval [lindex $line 1]}]} {
			alertnote "There is an error in the file HTMLAdditions.tcl with your custom elements."
			set htmlShownWarning 1
			break
		}
	}
	set htmlAdditionExist 1
}

#
# Color support
#

proc htmlColorizing {{changing 0}} {
 	global HTMLmodeVars HTMLwords htmlElemAttrOptional1 htmlElemAttrRequired1
 	global htmlElemEventHandler1 PREFS htmlElemKeyBinding
 	
 	set HTMLKeyWords {}
	if {[info exists HTMLwords]} {set HTMLKeyWords $HTMLwords}

	if {!$HTMLmodeVars(simpleColoring)} {
		# All HTML elements
		set allHTMLwords [concat {A ABBR ACRONYM ADDRESS APPLET AREA B BASE 
		BASEFONT BDO BGSOUND BIG BLINK BLOCKQUOTE BODY BR BUTTON CAPTION 
		CENTER CITE CODE COL COLGROUP DD DEL DFN DIR DIV DL DT EM EMBED 
		FIELDSET FONT FORM FRAME FRAMESET H1 H2 H3 H4 H5 H6 HEAD HR HTML I 
		IFRAME ILAYER IMG INPUT INS ISINDEX KBD KEYGEN LABEL LAYER LEGEND 
		LI LINK MAP MARQUEE MENU META MULTICOL NOBR NOEMBED NOFRAMES 
		NOLAYER NOSCRIPT OBJECT OL OPTGROUP OPTION P PARAM PRE Q S SAMP 
		SCRIPT SELECT SERVER SMALL SPACER SPAN STRIKE STRONG STYLE SUB SUP TABLE 
		TBODY TD TEXTAREA TFOOT TH THEAD TITLE TR TT U UL VAR WBR} [array names htmlElemKeyBinding]]
	
		foreach elem $allHTMLwords {
			lappend allHTMLkeywords "<${elem}" "/${elem}"
		}
		# All attributes
		set attributeWords {ABBR= ABOVE= ACCEPT-CHARSET= ACCEPT= ACCESSKEY= 
		ACTION= ALIGN= ALINK= ALT= ARCHIVE= AUTOPLAY= AUTOSTART= AXIS= 
		BACKGROUND= BEHAVIOR= BELOW= BGCOLOR= BGPROPERTIES= BORDER= 
		BORDERCOLOR= BORDERCOLORDARK= BORDERCOLORLIGHT= CELLPADDING= 
		CELLSPACING= CHALLENGE= CHAR= CHAROFF= CHARSET= CHECKED CITE= 
		CLASS= CLASSID= CLEAR= CLIP= CODE= CODEBASE= CODETYPE= COLOR= COLS= 
		COLSPAN= COMPACT CONSOLE= CONTENT= CONTROLLER= CONTROLS CONTROLS= 
		COORDS= CORRECTION= DATA= DATETIME= DECLARE DEFER DIR= DIRECTION= 
		DISABLED DYNSRC= ENCTYPE= FACE= FOR= FOV= FRAME= FRAMEBORDER= 
		FRAMESPACING= GUTTER= HEADERS= HEIGHT= HIDDEN= HREF= HREFLANG= 
		HSPACE= HTTP-EQUIV= ID= ISMAP LABEL= LANG= LANGUAGE= LEFT= 
		LEFTMARGIN= LINK= LONGDESC= LOOP= LOWSRC= MARGINHEIGHT= 
		MARGINWIDTH= MAXLENGTH= MAYSCRIPT MEDIA= METHOD= MULTIPLE NAME= 
		NODE= NOHREF NOLABELS= NORESIZE NOSHADE NOWRAP OBJECT= PAGEX= 
		PAGEY= PAN= PLAYEVERYFRAME= PLUGINSPAGE= POINT-SIZE= PROFILE= 
		PROMPT= READONLY REL= REV= ROWS= ROWSPAN= RULES= SCHEME= SCOPE= 
		SCROLLAMOUNT= SCROLLDELAY= SCROLLING= SELECTED SHAPE= SIZE= SPAN= 
		SRC= STANDBY= START= STYLE= SUMMARY= TABINDEX= TARGET= TEXT= TILT= 
		TITLE= TOP= TOPMARGIN= TYPE= USEMAP= VALIGN= VALUE= VALUETYPE= 
		VISIBILITY= VLINK= VSPACE= WIDTH= WRAP= Z-INDEX=}
		# Custom element attributes
		if {[file exists $PREFS:HTMLadditions.tcl] && ![catch {open $PREFS:HTMLadditions.tcl} fid]} {
			set lines [lrange [split [read -nonewline $fid] "\n"] 1 end]
			close $fid
			foreach line $lines {
				set cmd [lindex $line 1]
				set added ""
				regexp {([^\(]+)\(([^\)]+)\)[ ]+(.+)} [lrange $cmd 1 end] dummy var arg added
				set added [string trimleft [string trimright $added \}] \{]
				if {$var == "htmlElemAttrRequired1" || $var == "htmlElemAttrOptional1"} {
					foreach attr $added {
						if {[lsearch -exact $attributeWords $attr] < 0} {
							lappend attributeWords $attr
						}
					}
				}
			}
		}
		lappend attributeWords "FILE=" "FORM="
		# JavaScript keywords.
		set JavaScriptWords {break case continue default delete do export for import in 
		function if else new return switch this typeof var void while with true false 
		onAbort= onBlur= onChange= onClick= onDblClick= onError= onFocus= 
		onKeyDown= onKeyPress= onKeyUp= onLoad= onMouseDown= onMouseMove= 
		onMouseOut= onMouseOver= onMouseUp= onReset= onSelect= onSubmit= onUnload=}
		# CSS keywords
		set CSSwords {font-family font-style font-variant font-weight font-size font 
		color background-color background-image background-repeat background-attachment
		background-position background word-spacing letter-spacing text-decoration
		vertical-align text-transform text-align text-indent line-height
		margin-top margin-right margin-bottom margin-left margin padding-top padding-right
		padding-bottom padding-left padding border-top-width border-right-width
		border-bottom-width border-left-width border-width border-color border-style
		border-top border-right border-bottom border-left border width height float clear
		display white-space list-style-type list-style-image list-style-position list-style
		@import important}
		
		if {!$changing} {
			regModeKeywords -i "<" -i ">" -I $HTMLmodeVars(tagColor) \
				-s $HTMLmodeVars(stringColor)  -b "/*" "*/" -e "//" HTML {}
		}
		if {$HTMLmodeVars(JavaScriptColoring) || $HTMLmodeVars(CSSColoring)} {
			set col $HTMLmodeVars(JavaCommentColor)
		} else {
			set col none
		}
		regModeKeywords -a -c $col HTML
		if {$HTMLmodeVars(JavaScriptColoring)} {
			set col $HTMLmodeVars(JavaScriptColor)
		} else {
			set col none
		}
		regModeKeywords -a -k $col HTML $JavaScriptWords
		if {$HTMLmodeVars(CSSColoring)} {
			set col $HTMLmodeVars(CSSColor)
		} else {
			set col none
		}
		regModeKeywords -a -k $col HTML $CSSwords
		regModeKeywords -a -k $HTMLmodeVars(tagColor) \
		HTML [concat $HTMLKeyWords $allHTMLkeywords]
		regModeKeywords -a -k $HTMLmodeVars(attributeColor) HTML $attributeWords
		regModeKeywords -a -k $HTMLmodeVars(JavaCommentColor) HTML {"<!--" "-->" "#INCLUDE" "/#INCLUDE"
		"#LASTMODIFIED" "/#LASTMODIFIED" "#DOCINDEX" "/#DOCINDEX"}
	} else {
		regModeKeywords -b "<" ">" -c $HTMLmodeVars(tagColor) \
		-k $HTMLmodeVars(tagColor) HTML $HTMLKeyWords
	}
}

# Change color when a color variable is changed.
proc htmlChangeColorizing {flag} {
	global HTMLmodeVars
	set msg 0
	switch -glob $flag {
		simpleColoring {
			htmlColorizing
			set msg 1
		}
		JavaScriptColoring -
		attributeColor -
		CSSColoring {
			if {!$HTMLmodeVars(simpleColoring)} {
				htmlColorizing 1
			}
		}
		tagColor {
			if {$HTMLmodeVars(simpleColoring)} {
				regModeKeywords -a -c $HTMLmodeVars(tagColor) HTML
			} else {
				regModeKeywords -a -i "<" -i ">" -I $HTMLmodeVars(tagColor) HTML
				htmlColorizing 1
			}
		}
		JavaScriptColor {
			if {$HTMLmodeVars(JavaScriptColoring) && !$HTMLmodeVars(simpleColoring)} {
				htmlColorizing 1
			}
		}
		JavaCommentColor {
			if {($HTMLmodeVars(JavaScriptColoring) || $HTMLmodeVars(CSSColoring)) && !$HTMLmodeVars(simpleColoring)} {
				regModeKeywords -a -c $HTMLmodeVars(JavaCommentColor) HTML
			}
		}
		CSSColor {
			if {$HTMLmodeVars(CSSColoring) && !$HTMLmodeVars(simpleColoring)} {
				htmlColorizing 1
			}
		}	
		stringColor {
			if {!$HTMLmodeVars(simpleColoring)} {
				regModeKeywords -a -s $HTMLmodeVars(stringColor) HTML
			}
		}
	}
	refresh
	if {$msg} {message "Coloring may not change until you switch to another window."}
}

trace variable browserSig w htmlToggleBrowser2

# Dialog to set HTML mode variables.
proc HTMLmodifyFlags {{which General}} {
	global HTMLmodeVars modifiedModeVars htmlIconTxt htmlIcons htmlMenu htmlUtilsMenu
	
	if {$which == "Attributes"} {htmlGlobalAttrsPrefs; return}
	
	set box [eval html${which}PrefsBox]
	set allFlags [eval html${which}Flags]

	set attrTxt {"status bar" "dialog boxes"}
	set manTxt {"first page in manual" "table of contents without frames" "table of contents with frames"}
	set values [eval [concat dialog -w 460 -h 315 -b OK 20 285 85 305 -b Cancel 110 285 175 305 $box]]
	if {[lindex $values 1]} {return}
	if {$which == "General" && [lindex $values 22] == [lindex $values 23]} {
		alertnote "You can't use the same menu icon for both menus. Menu icon changes are ignored."
		set allFlags [lrange $allFlags 0 18]
	}
	set i 1
	if {$which == "General"} {incr i}
	foreach flag $allFlags {
		global $flag
		incr i
		set val [lindex $values $i]
		if {$flag == "useBigWindows" || $flag == "changeInBigWindows"} {set val [lsearch -exact $attrTxt $val]}
		if {$flag == "manualStartPage"} {set val [lsearch -exact $manTxt $val]}
		if {[string match "*Icon" $flag]} {set val [lindex $htmlIcons [lsearch $htmlIconTxt $val]]}
		if {$HTMLmodeVars($flag) != $val} {
			set $flag $val
			set HTMLmodeVars($flag) $val
			lappend modifiedModeVars [list $flag HTMLmodeVars]
			if {[string match "*Color*" $flag]} {htmlChangeColorizing $flag}
			if {[string match "*Icon" $flag]} {
				removeMenu [set [string trim $flag "Icon"]]
				set [string trim $flag "Icon"] $val
				eval htmlBuild[string trim $flag Iconhtml]
			}
		}
	}
}

proc htmlGeneralPrefsBox {} {
	global HTMLmodeVars htmlIconTxt htmlIcons alpha::colors elecStopMarker
	
	set attrTxt {"status bar" "dialog boxes"}
	set manTxt {"first page in manual" "table of contents without frames" "table of contents with frames"}

	set box "-t {General HTML mode Preferences} 100 10 450 30 \
	-m {{Page 1 of preferences} {Page 1 of preferences} {Page 2 of preferences} {Page 3 of preferences}} 100 35 300 55 \
	-n {Page 1 of preferences} \
	-c {Bring browser to front when sending a window to it} $HTMLmodeVars(browseInForeground) 10 65 450 80\
	-c {Save window without asking when sending it to the browser} $HTMLmodeVars(saveWithoutAsking) 10 85 450 100 \
	-c {Set tags in lower case} $HTMLmodeVars(useLowerCase) 10 105 200 120 \
	-c {Use template stops ($elecStopMarker)} $HTMLmodeVars(useTabMarks) 10 125 450 140 \
	-c {<P> has a closing tag </P>} $HTMLmodeVars(pIsContainer) 10 145 450 160 \
	-c {<LI>, <DT> and <DD> have closing tags} $HTMLmodeVars(lidtAreContainers) 10 165 450 180 \
	-t {Give attributes in}  10 185 150 200\
	-m {[list [lindex $attrTxt $HTMLmodeVars(useBigWindows)]] {dialog boxes} {status bar}} 155 185 450 205 \
	-t {Change attributes in} 10 210 150 225 \
	-m {[list [lindex $attrTxt $HTMLmodeVars(changeInBigWindows)]] {dialog boxes} {status bar}} 155 210 450 230 \
	-c {Beep for first attribute (applies only if you use the status bar)} $HTMLmodeVars(promptNoisily) 10 235 450 250 \
	-c {Flash status bar for first attribute} $HTMLmodeVars(flashStatusBar) 10 255 450 270 \
	-n {Page 2 of preferences} \
	-c {Simple coloring} $HTMLmodeVars(simpleColoring) 10 65 450 80 \
	-t {Color of HTML tags:} 10 85 150 100 \
	-m [list [concat $HTMLmodeVars(tagColor) ${alpha::colors}]] 160 85 310 105 \
	-t {Color of attributes:} 10 110 150 125 \
	-m [list [concat $HTMLmodeVars(attributeColor) ${alpha::colors}]] 160 110 310 130 \
	-t {Color of strings:} 10 135 150 150 \
	-m [list [concat $HTMLmodeVars(stringColor) ${alpha::colors}]] 160 135 310 155 \
	-t {'Help' opens} 10 160 95 175 \
	-m {[concat [list [lindex $manTxt $HTMLmodeVars(manualStartPage)]] $manTxt]} 100 160 450 180 \
	-c {Cmd-double-clicking on non-text file link opens file} $HTMLmodeVars(openNonTextFile) 10 190 450 205 \
	-c {Return on non-text file in home page window opens file} $HTMLmodeVars(homeOpenNonTextFile) 10 210 450 225 \
	-c {'Insert include tags' only inserts tags} $HTMLmodeVars(includeOnlyTags) 10 230 450 245 \
	-n {Page 3 of preferences} \
	-t {'Last modified' text} 10 65 150 80 -e [list $HTMLmodeVars(lastModified)] 160 65 450 80 \
	-t {HTML menu icon:} 10 90 170 105 \
	-m [list [concat [list [lindex $htmlIconTxt [lsearch $htmlIcons $HTMLmodeVars(htmlMenuIcon)]]] $htmlIconTxt]] 180 90 450 110 \
	-t {HTML Utilities menu icon:} 10 115 170 130 \
	-m [list [concat [list [lindex $htmlIconTxt [lsearch $htmlIcons $HTMLmodeVars(htmlUtilsMenuIcon)]]] $htmlIconTxt]] 180 115 450 135"

	return $box
}

proc htmlGeneralFlags {} {
	return [list browseInForeground saveWithoutAsking useLowerCase useTabMarks pIsContainer lidtAreContainers \
	useBigWindows changeInBigWindows promptNoisily flashStatusBar simpleColoring \
	tagColor attributeColor stringColor manualStartPage openNonTextFile homeOpenNonTextFile \
	includeOnlyTags lastModified htmlMenuIcon htmlUtilsMenuIcon]
}

proc htmlIndentationPrefsBox {} {
	global HTMLmodeVars htmlIndentElements
	set box "-t {HTML mode Indentation Preferences} 100 10 450 30 \
	-t {Indent the content of} 10 40 450 55"
	set ww 70; set hh 10
	foreach ind $htmlIndentElements {
		append box " -c $ind $HTMLmodeVars(indent${ind}) $hh $ww [expr $hh + 100] [expr $ww + 15]"
		incr ww 20
		if {$ww > 200} {
			set ww 70
			incr hh 110
		}
	}
	return $box
}

proc htmlIndentationFlags {} {
	global htmlIndentElements
	return "indent[join $htmlIndentElements " indent"]"
}	

if {![alpha::package vsatisfies ${alpha::version} 7.1b1]} {
proc htmlJavaScriptPrefsBox {} {
	global HTMLmodeVars alpha::colors
	set box "-t {HTML mode JavaScript and CSS Preferences} 100 10 450 30 \
	-c {Electric left braces} $HTMLmodeVars(elecLBrace) 10 35 450 50 \
	-c {Electric right braces} $HTMLmodeVars(elecRBrace) 10 55 450 70 \
	-c {Electric semicolon} $HTMLmodeVars(electricSemi) 10 75 450 90 \
	-c {Color JavaScript keywords} $HTMLmodeVars(JavaScriptColoring) 10 95 450 110\
	-t {Color of JavaScript keywords:} 10 115 215 130 \
	-m [list [concat $HTMLmodeVars(JavaScriptColor) ${alpha::colors}]] 220 115 360 135 \
	-c {Color CSS keywords} $HTMLmodeVars(CSSColoring) 10 165 450 180\
	-t {Color of CSS keywords:} 10 185 215 200 \
	-m [list [concat $HTMLmodeVars(CSSColor) ${alpha::colors}]] 220 185 360 205 \
	-t {Color of JavaScript and CSS comments:} 10 210 270 225 \
	-m [list [concat $HTMLmodeVars(JavaCommentColor) ${alpha::colors}]] 275 210 420 230"
	
	return $box
}

proc htmlJavaScriptFlags {} {
	return [list  elecLBrace elecRBrace electricSemi\
	JavaScriptColoring JavaScriptColor CSSColoring CSSColor JavaCommentColor]
}
} else {
proc htmlJavaScriptPrefsBox {} {
	global HTMLmodeVars alpha::colors
	set box "-t {HTML mode JavaScript and CSS Preferences} 100 10 450 30 \
	-c {Color JavaScript keywords} $HTMLmodeVars(JavaScriptColoring) 10 35 450 50\
	-t {Color of JavaScript keywords:} 10 55 215 70 \
	-m [list [concat $HTMLmodeVars(JavaScriptColor) ${alpha::colors}]] 220 55 360 75 \
	-c {Color CSS keywords} $HTMLmodeVars(CSSColoring) 10 105 450 120\
	-t {Color of CSS keywords:} 10 125 215 140 \
	-m [list [concat $HTMLmodeVars(CSSColor) ${alpha::colors}]] 220 125 360 145 \
	-t {Color of JavaScript and CSS comments:} 10 150 270 165 \
	-m [list [concat $HTMLmodeVars(JavaCommentColor) ${alpha::colors}]] 275 150 420 270"
	
	return $box
}

proc htmlJavaScriptFlags {} {
	return [list JavaScriptColoring JavaScriptColor CSSColoring CSSColor JavaCommentColor]
}
}

proc htmlCheckingPrefsBox {} {
	global HTMLmodeVars
	set box "-t {HTML mode Checking Links Preferences} 100 10 450 30 \
	-t {These settings apply when you check links with Alpha:} 10 40 450 55 \
	-c {Check anchors} $HTMLmodeVars(checkAnchors) 10 60 450 75 \
	-c {Case sensitive checking (slower)} $HTMLmodeVars(caseSensitive) 10 80 450 95 \
	-t {These settings apply when you check links with Big Brother:} 10 105 450 120\
	-c {Bring Big Brother to front when checking links} $HTMLmodeVars(checkInFront) 10 125 450 140\
	-c {Use Big Brother's link check options} $HTMLmodeVars(useBBoptions) 10 145 450 160\
	-c {Ignore remote links (if you don't use Big Brother's option)} $HTMLmodeVars(ignoreRemote) 30 165 450 180\
	-c {Ignore local links (if you don't use Big Brother's option)} $HTMLmodeVars(ignoreLocal) 30 185 450 200"
	return $box
}

proc htmlCheckingFlags {} {
	return [list checkAnchors caseSensitive checkInFront useBBoptions ignoreRemote ignoreLocal]
}

proc htmlWordPrefsBox {} {
	global HTMLmodeVars
	set box "-t {HTML mode Word Wrapping Preferences} 100 10 450 30 \
	-t {Line width:} 10 40 90 55 -e [list $HTMLmodeVars(fillColumn)] 100 40 140 55 \
	-t characters 145 40 300 55 \
	-t {The variables below determine which characters build up words, and the word wrapping. Normally\
	there is no need to change them. Read about them in general manual if you want to change them.} \
	10 70 450 130 \
	-t wordBreak: 10 140 150 155 -e [list $HTMLmodeVars(wordBreak)] 155 140 450 155 \
	-t wordBreakPreface: 10 165 150 180 -e [list $HTMLmodeVars(wordBreakPreface)] 155 165 450 180 \
	-t wrapBreak: 10 190 150 205 -e [list $HTMLmodeVars(wrapBreak)] 155 190 450 205 \
	-t wrapBreakPreface: 10 215 150 230 -e [list $HTMLmodeVars(wrapBreakPreface)] 155 215 450 230"
}

proc htmlWordFlags {} {
	return [list fillColumn wordBreak wordBreakPreface wrapBreak wrapBreakPreface]
}

proc htmlGlobalAttrsPrefs {} {
	global HTMLmodeVars modifiedModeVars
	set attrs " ID= CLASS= STYLE= TITLE= LANG= DIR= onClick= onDblClick= \
	 onMouseDown= onMouseUp= onMouseOver= onMouseMove= onMouseOut= onKeyPress= onKeyDown= onKeyUp="
	set alwaysask $HTMLmodeVars(alwaysaskforAttributes)
	set dontask $HTMLmodeVars(dontaskforAttributes)
	set hidden $HTMLmodeVars(neveraskforAttributes)
	htmlUseAttrsDialog "HTML mode Attributes Preferences" $attrs "" alwaysask hidden dontask 1
	set HTMLmodeVars(alwaysaskforAttributes) $alwaysask
	set HTMLmodeVars(dontaskforAttributes) $dontask
	set HTMLmodeVars(neveraskforAttributes) $hidden
	lappend modifiedModeVars {alwaysaskforAttributes HTMLmodeVars} {dontaskforAttributes HTMLmodeVars} {neveraskforAttributes HTMLmodeVars}
}

if {[file exists $PREFS:HTMLadditions.tcl]} {
	if {[catch {htmlReadAdditions}]} {alertnote "An error occured while reading your custom elements."}
}
rename htmlReadAdditions ""
rename htmlReadAdditions0 ""

htmlBuildMenu
htmlBuildUtilsMenu
htmlColorizing
# Check that all home page folders exist.
set tmp_notfind ""
foreach tmp_hp $HTMLmodeVars(homePages) {
	if {![file exists [lindex $tmp_hp 0]] || ![file isdirectory [lindex $tmp_hp 0]]} {
		alertnote "Can't find the folder for the home page [lindex $tmp_hp 1][lindex $tmp_hp 2]"
		set tmp_notfind "[lindex $tmp_hp 1][lindex $tmp_hp 2]"
	}
}
if {$tmp_notfind != ""} {htmlHomePages $tmp_notfind}
catch {unset tmp tmp_notfind tmp_hp}

# Define a couple of key bindings.
if {[file exists "$PREFS:HTML:HTML entity keys"]} {
	source "$PREFS:HTML:HTML entity keys"
} else {		
	if {![info exists htmlEntityKeys([list less than])]} {
		set htmlEntityKeys([list less than]) "<U<B<I/,"
		set htmlEntityKeysProc([list less than]) {htmlInsertCharacter "less than"}
	}
	if {![info exists htmlEntityKeys([list greater than])]} {
		set htmlEntityKeys([list greater than]) "<U<B<I/."
		set htmlEntityKeysProc([list greater than]) {htmlInsertCharacter "greater than"}
	}
	if {![info exists htmlEntityKeys(ampersand)]} {
		set htmlEntityKeys(ampersand) "<U<B<I/7"
		set htmlEntityKeysProc(ampersand) {htmlInsertCharacter ampersand}
	}
	if {![info exists htmlEntityKeys([list nonbreak space])]} {
		set htmlEntityKeys([list nonbreak space]) "<U<B<I/ "
		set htmlEntityKeysProc([list nonbreak space]) {htmlInsertCharacter "nonbreak space"}
	}
	htmlSaveCache "HTML entity keys" "array set htmlEntityKeys [list [array get htmlEntityKeys]]\rarray set htmlEntityKeysProc [list [array get htmlEntityKeysProc]]"
}

bind::fromArray htmlEntityKeys htmlEntityKeysProc 0 HTML
catch {unset htmlEntityKeys htmlEntityKeysProc}

proc htmlBindBraces {args} {
	global bind::LeftBrace bind::RightBrace
	eval bind [keys::toBind ${bind::LeftBrace}] htmlLeftBrace HTML
	eval bind [keys::toBind ${bind::RightBrace}] htmlRightBrace HTML
}
htmlBindBraces
trace variable bind::LeftBrace w htmlBindBraces
trace variable bind::RightBrace w htmlBindBraces

# Comment line
bind 'l' <C>  htmlCommentLine HTML


# Register hooks
hook::register saveHook htmlUpdateLastMod HTML
hook::register saveasHook htmlUpdateLastMod HTML
hook::register quitHook htmlQuitHook
hook::register closeHook htmlCloseHook Home
hook::register deactivateHook htmldeactivateHook Home
hook::register activateHook htmlActivateHook HTML
hook::register openHook htmlActivateHook HTML

proc HTML::OptionTitlebar {} {
	global htmlPopUptag
	return [set htmlPopUptag [htmlGetAttributes]]
}

proc HTML::OptionTitlebarSelect {item} {
	global htmlPopUptag
	if {[lsearch -exact $htmlPopUptag $item] >= 0} {
		htmlInsertAttributes $item
	} else {
		error "Not an attibute."
	}
}

if {![alpha::package vsatisfies ${alpha::version} 7.1b1]} {
proc htmlLeftBrace {} {
	global elecLBrace
	set old $elecLBrace
	if {![htmlIsInContainer SCRIPT] && ![htmlIsInContainer STYLE]} {
		set elecLBrace 0
	}
	catch {bind::LeftBrace}
	set elecLBrace $old
}
proc htmlRightBrace {} {
	global elecRBrace
	set old $elecRBrace
	if {![htmlIsInContainer SCRIPT] && ![htmlIsInContainer STYLE]} {
		set elecRBrace 0
	}
	catch {bind::RightBrace}
	set elecRBrace $old
}
} else {
proc htmlLeftBrace {} {
	global electricBraces
	set old $electricBraces
	if {![htmlIsInContainer SCRIPT] && ![htmlIsInContainer STYLE]} {
		set electricBraces 0
	}
	catch {bind::LeftBrace}
	set electricBraces $old
}
proc htmlRightBrace {} {
	global electricBraces
	set old $electricBraces
	if {![htmlIsInContainer SCRIPT] && ![htmlIsInContainer STYLE]} {
		set electricBraces 0
	}
	catch {bind::RightBrace}
	set electricBraces $old
}
}
if {[info exists cssModeIsLoaded] && $htmlVersion != $cssVersion} {
	alertnote "Warning: The versions of HTML mode and CSS mode may not be compatible.\
		Always install new versions of HTML mode and CSS mode simultaneously."
}

set htmlModeIsLoaded 1

message "HTML initialization complete."
